(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     46069,       1369]*)
(*NotebookOutlinePosition[     46941,       1402]*)
(*  CellTagsIndexPosition[     46867,       1396]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Matem\[AAcute]ticas con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Title"],

Cell["Derivadas e integrales", "Subtitle"],

Cell[CellGroupData[{

Cell["Rectas tangentes y normales a una curva", "Section"],

Cell[TextData[{
  "La recta que pasa por dos puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, c)\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((b, d)\)\(\ \)\)\)]],
  "con ",
  Cell[BoxData[
      \(TraditionalForm\`a \[NotEqual] b\)]],
  StyleBox[", ",
    FontSlant->"Italic"],
  "tiene como ecuaci\[OAcute]n cartesiana ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(\(c - d\)\/\(a - b\)\) 
            x + \(a\ d - b\ c\)\/\(a - b\)\)]],
  ". Definimos el comando siguiente:"
}], "Text"],

Cell[BoxData[{
    \(\(recta[{a_, c_}, {b_, d_}]\)[x_] := 
      \(c - d\)\/\(a - b\)*x + \(a*d - b*c\)\/\(a - b\) /; 
        a \[NotEqual] b\), 
    \(\(recta[{a_, c_}, {a_, d_}]\)[x_] := "\<es una recta vertical\>"\)}], 
  "Input"],

Cell[TextData[{
  "La tangente a la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  " es la recta de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y - f(a) = f\ ' \((a)\) \((x - a)\)\)]],
  ". Definimos el comando siguiente:"
}], "Text"],

Cell[BoxData[
    \(\(tangente[f_, a_]\)[x_] := f[a] + \(f'\)[a]*\((x - a)\)\)], "Input"],

Cell[BoxData[{
    \(f[x_] := \((x - 2)\)^2\), 
    \(\(tangente[f, 1]\)[x]\)}], "Input"],

Cell[TextData[{
  "La normal a la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  " es la recta de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y - f(a) = \(a - x\)\/\(f\ ' \((a)\)\)\)]],
  ". Definimos el comando siguiente:"
}], "Text"],

Cell[BoxData[{
    \(\(rectanormal[f_, a_]\)[x_] := 
      f[a] + \(a - x\)\/\(f'\)[a] /; \(f'\)[a] \[NotEqual] 0\), 
    \(\(rectanormal[f_, a_]\)[x_] := 
      Print["\<la derivada de f[x]=\>"\ , f[x], \ "\< es nula en x=\>", \ a]
          \  /; \(f'\)[a] \[Equal] 0\)}], "Input"],

Cell[BoxData[{
    \(\(rectanormal[f, 1]\)[x]\), 
    \(\(rectanormal[f, 2]\)[x]\)}], "Input"],

Cell[TextData[{
  "Ahora puedes representar gr\[AAcute]ficamente una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", su tangente en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((a, f(a))\)\ \)\)]],
  "y las rectas secantes por los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((a + h, f(a + h))\)\)]],
  " para distintos valores de ",
  StyleBox["h",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[{
    RowBox[{\(Clear[f]; \nf[x_] := \(-\((x - 3)\)^2\) + 6; \n
      Do[Plot[{f[x], \(tangente[f, 1]\)[x], 
            \(recta[{1, f[1]}, {1 - h, f[1 - h]}]\)[x]}, {x, \(-2\), 5}, 
          PlotRange \[Rule] {\(-2\), 8}, 
          PlotStyle -> {RGBColor[0, 0, 1], RGBColor[0, 0, 0], 
              RGBColor[1, 0, 0]}, ImageSize -> {443, 273}], {h, \(-3\), 
          \(- .2\),  .2}]\), 
      RowBox[{"(*", " ", 
        StyleBox[
          \(en\ esta\ animaci\[OAcute]n\ vemos\ la\ gr\[AAcute]fica\ de\ f\ en
            \ azul, \ 
          la\ recta\ tangente\ en\ el\ punto\ \((1, f[1])\)\ en\ negro\ y\ las
            \ rectas\ secantes\ en\ rojo\),
          FontColor->RGBColor[1, 0, 0]], " ", "*)"}]}], 
  \(SelectionMove[EvaluationNotebook[], All, GeneratedCell]; \n
    FrontEndTokenExecute["\<CellGroup\>"]\), 
    RowBox[{\(FrontEndTokenExecute["\<OpenCloseGroup\>"]\), 
      RowBox[{"(*", " ", 
        StyleBox[
          \(este\ c\[OAcute]digo\ es\ para\ que\ todas\ las\ celdas\ generadas
            \ se\ mantengan\ juntas\),
          FontColor->RGBColor[1, 0, 0]], " ", "*)"}]}]}], "Input"]
}, Open  ]],

Cell[TextData[{
  "Podemos representar tambi\[EAcute]n las familias de rectas tangentes y \
normales a una curva. Aqu\[IAcute] tienes la familia de las tangentes a la \
par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(\(x\^2\/4\)\(.\)\)\)]]
}], "Text"],

Cell[BoxData[{
    \(Clear[f]; f[x_] := x^2/4\), 
    \(\(Show[\[IndentingNewLine]\t
      Table[\[IndentingNewLine]\t\t
        Plot[{f[x], \(tangente[f, \(-3\) + 6  k/30]\)[x]}, {x, \(-3\), 3}, 
          PlotRange \[Rule] {\(-2\), 2.5}, 
          PlotStyle \[Rule] {{Hue[0], Thickness[ .01]}, {Hue[ .65]}}, 
          AspectRatio \[Rule] 1.1, 
          DisplayFunction \[Rule] Identity\[IndentingNewLine]\t\t\t], 
        \[IndentingNewLine]{k, 1, 29}], \[IndentingNewLine]\t\t
      DisplayFunction \[Rule] $DisplayFunction]; \)\)}], "Input"],

Cell[TextData[{
  "Aqu\[IAcute] tienes la familia de las normales a la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(\(x\^2\/4\)\(.\)\)\)]],
  " Observa que todas ellas son tangentes a una curva, llamada la evoluta de \
la par\[AAcute]bola, que es una par\[AAcute]bola c\[UAcute]bica de ecuaci\
\[OAcute]n ",
  Cell[BoxData[
      \(y = 2 + \@\(\(27\/4\) x\^2\)\%3\)]],
  ". Dicha curva se ha representado junto con las normales."
}], "Text"],

Cell[BoxData[{
    \(Clear[f]; f[x_] := x^2/4\), 
    \(\(Show[\[IndentingNewLine]\t
      Table[\[IndentingNewLine]\t\t
        Plot[{f[x], \(rectanormal[f, \(-6\) + 12  k/121]\)[x], 
            2 + \@\(\(27\/4\) x\^2\)\%3}, {x, \(-6\), 6}, 
          PlotRange \[Rule] {\(-6\), 10}, 
          PlotStyle 
            \[Rule] {{Hue[0], Thickness[ .01]}, {Hue[ .65]}, {Hue[0], 
                Thickness[ .007]}}, AspectRatio \[Rule] Automatic, 
          DisplayFunction \[Rule] Identity\[IndentingNewLine]\t\t\t], 
        \[IndentingNewLine]{k, 1, 120}], \[IndentingNewLine]\t\t
      DisplayFunction \[Rule] $DisplayFunction]; \)\)}], "Input"],

Cell[TextData[{
  "Aqu\[IAcute] tienes la familia de las normales a la elipse ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\/9 + y\^2\/4 = 1. \)]],
  " Observa que todas ellas son tangentes a una curva, llamada la evoluta de \
la elipse, cuya ecuaci\[OAcute]n es ",
  Cell[BoxData[
      RowBox[{
        StyleBox["y"], 
        StyleBox["="], 
        StyleBox[\(1\/6\ \((9 - \@\(\((12  x)\)\^2\)\%3)\)\^\(3/2\)\)]}]]],
  ". Dicha curva se ha representado junto con las normales."
}], "Text"],

Cell[BoxData[
    \(Clear[f]; \ f[x_] := \(3\/2\) \@\(1 - x\^2\/9\); h[x_] := \(-f[x]\); \n
    Show[\[IndentingNewLine]\t{\[IndentingNewLine]\t
        Table[\[IndentingNewLine]\t\t
          Plot[{f[x], \(normal[f, \(-3\) + 6  k/61]\)[x], h[x], 
              \(normal[h, \(-3\) + 6  k/61]\)[x]}, {x, \(-3\), 3}, 
            PlotRange \[Rule] {\(-5\), 5}, 
            PlotStyle \[Rule] {{Hue[0], Thickness[ .01]}, {Hue[ .65]}}, 
            AspectRatio \[Rule] Automatic, 
            DisplayFunction \[Rule] Identity\[IndentingNewLine]\t\t\t], 
          \[IndentingNewLine]{k, 1, 59}\[IndentingNewLine]\t\t],  (*\ 
          representamos\ ahora\ la\ evoluta\ *) 
          \[IndentingNewLine]Plot[{
            \(-\(1\/6\)\)\ \((9 - \@\(\((12  x)\)\^2\)\%3)\)\^\(3/2\), 
            1\/6\ \((9 - \@\(\((12  x)\)\^2\)\%3)\)\^\(3/2\)}, {x, \(-9\)/4, 
            9/4}, PlotStyle 
            \[Rule] {{Hue[0], Thickness[ .008]}, {Hue[0], Thickness[ .008]}}, 
          AspectRatio \[Rule] Automatic, 
          DisplayFunction \[Rule] Identity\[IndentingNewLine]\t]
          \[IndentingNewLine]\t}, \[IndentingNewLine]\t\t
      DisplayFunction \[Rule] $DisplayFunction\[IndentingNewLine]\t]; \)], 
  "Input"],

Cell[CellGroupData[{

Cell["Cocientes incrementales", "Section"],

Cell["\<\
Podemos aproximar la derivada de una funci\[OAcute]n por los cocientes \
incrementales. \
\>", "Text"],

Cell[BoxData[
    \(\(cocienteinc[f_, h_]\)[x_] := \(f[x + h] - f[x]\)\/h\)], "Input"],

Cell[BoxData[{
    RowBox[{
      \(Do[Plot[
          Evaluate[{Sin[x], \(cocienteinc[Sin, \(-h\)]\)[x], Cos[x]}], {x, 0, 
            2  \[Pi]}, PlotRange \[Rule] {\(-1.2\), 1.2}, 
          PlotStyle -> {RGBColor[0, 0, 0], RGBColor[1, 0, 0], 
              RGBColor[0, 1, 0]}], {h, \(-2\), \(- .1\),  .2}]\), 
      RowBox[{"(*", " ", 
        StyleBox[
          \(en\ esta\ animaci\[OAcute]n\ se\ ve\ la\ funci\[OAcute]n\ seno\ en
            \ negro, \ 
          los\ cocientes\ incrementales\ en\ rojo\ y\ la\ funci\[OAcute]n\ 
            coseno\ en\ verde\),
          FontColor->RGBColor[1, 0, 0]], " ", "*)"}]}], 
  \(SelectionMove[EvaluationNotebook[], All, GeneratedCell]; \n
    FrontEndTokenExecute["\<CellGroup\>"]\), 
  \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\)}], "Input"]
}, Open  ]],

Cell["Crecimiento, decrecimiento, concavidad, convexidad", "Section"],

Cell["\<\
Podemos dibujar las partes de la gr\[AAcute]fica de una funci\[OAcute]n en \
las que hay crecimiento de distinto color de aquellas en que hay \
decrecimiento. El siguiente comando representa la gr\[AAcute]fica de  una \
funci\[OAcute]n y colorea de azul los tramos donde hay crecimiento y de rojo \
los tramos en que hay decrecimiento.\
\>", "Text"],

Cell[BoxData[
    \(\(\(monotonia[func_, {var_, a_, b_}, n_, opts___] := 
        Show[Table[
            Graphics[\ {Hue[
                  If[\((D[func, var] /. 
                          var -> a + \((k - 1)\)*N[\((b - a)\)/n])\) > 
                      0,  .66,  .0]], \ Thickness[ .007], \ 
                Line[{{a + \((k - 1)\)*N[\((b - a)\)/n], 
                      func /. var -> a + \((k - 1)\)*N[\((b - a)\)/n]}, {a + 
                        k*N[\((b - a)\)/n], 
                      func /. var \[Rule] a + k*N[\((b - a)\)/n]}}]}], \ {k, 
              1, n}], opts];\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(f[x_]\  := \ Product[x - c, {c, \(-2\), 2}];\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(grafmono = 
        monotonia[f[x], {x, \(-2\), 2}, 100, \ Frame -> True, \ Axes -> True, 
          AspectRatio \[Rule] Automatic, 
          ImageSize -> {159, 288}];\)\)], "Input"],

Cell["\<\
Lo mismo podemos hacer para distinguir la concavidad de la convexidad.\
\>", "Text"],

Cell[BoxData[
    \(\(\(concavidad[func_, {var_, a_, b_}, n_, opts___] := 
        Show[Table[
            Graphics[\ {Hue[
                  If[\((D[func, var, var] /. 
                          var -> a + \((k - 1)\)*N[\((b - a)\)/n])\) > 
                      0,  .33,  .0]], \ Thickness[ .007], \ 
                Line[{{a + \((k - 1)\)*N[\((b - a)\)/n], 
                      func /. var -> a + \((k - 1)\)*N[\((b - a)\)/n]}, {a + 
                        k*N[\((b - a)\)/n], 
                      func /. var \[Rule] a + k*N[\((b - a)\)/n]}}]}], \ {k, 
              1, n}], opts];\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(grafconca = 
        concavidad[f[x], {x, \(-2\), 2}, 100, \ Axes -> True, \ 
          Frame -> True, AspectRatio \[Rule] Automatic, 
          ImageSize -> {159, 288}];\)\)], "Input"],

Cell["\<\
Compara ahora las gr\[AAcute]ficas de la funci\[OAcute]n y de sus dos \
primeras derivadas. Para poder ver las tres gr\[AAcute]ficas juntas con \
comodidad hemos dividido por 5 las funciones derivadas (lo que equivale a un \
cambio de escala en sus representaciones gr\[AAcute]ficas). Observa \
atentamente las gr\[AAcute]ficas procurando entender las relaciones que hay \
entre ellas.\
\>", "Text"],

Cell[BoxData[
    \(\(grafderf = 
        Plot[\(f'\)[x]/5, {x, \(-2\), 2}, \ Axes -> True, \ Frame -> True, 
          PlotRange \[Rule] {\(-4\), 4}, AspectRatio \[Rule] Automatic, 
          ImageSize -> {159, 288}, 
          DisplayFunction \[Rule] Identity];\)\)], "Input"],

Cell[BoxData[
    \(\(grafderdosf = 
        Plot[\(f''\)[x]/5, {x, \(-2\), 2}, Axes -> True, \ Frame -> True, 
          PlotRange \[Rule] {\(-4\), 4}, AspectRatio \[Rule] Automatic, 
          ImageSize -> {159, 288}, 
          DisplayFunction \[Rule] Identity];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[{grafmono, grafderf}, 
        PlotRange \[Rule] {\(-4\), 4}];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[{grafconca, grafderdosf}, 
        PlotRange \[Rule] {\(-4\), 4}];\)\)], "Input"]
}, Open  ]],

Cell[BoxData[
    \(\(Plot[{f[x], \(f'\)[x]/5, \(f''\)[x]/5}, {x, \(-2\), 2}, 
        PlotStyle \[Rule] {Hue[ .0], Hue[ .66], Hue[ .33]}, \ Axes -> True, \ 
        Frame -> True, PlotRange \[Rule] {\(-4\), 4}, 
        AspectRatio \[Rule] Automatic, ImageSize -> {159, 288}];\)\)], "Input"],

Cell["Ejercicios", "Subsection"],

Cell["\<\
Utiliza los comandos antes definidos para resolver los siguientes ejercicios.\
\
\>", "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 1",
    FontWeight->"Bold"],
  ". Calcula las tangentes a la hip\[EAcute]rbola ",
  Cell[BoxData[
      \(TraditionalForm\`x\ y = 1\)]],
  " que pasan por el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(-1\), 1)\)\)]],
  ". Haz una representaci\[OAcute]n gr\[AAcute]fica."
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 2",
    FontWeight->"Bold"],
  ". Calcula las tangentes a la gr\[AAcute]fica de  ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2\ x\^3 + 13  x\^2 + 5  x + 9\)]],
  " que pasan por el origen. Haz una representaci\[OAcute]n gr\[AAcute]fica.\n\
",
  StyleBox["Ejercicio 3.",
    FontWeight->"Bold"],
  " Calcula la m\[IAcute]nima distancia entre las par\[AAcute]bolas ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) = x\^2 + 2  x + 2, \ 
      g(x) = \(-x\^2\) + 6  x\  - 4\)]],
  ". Ten en cuenta que si ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((b, g(b))\)\)]],
  " son los puntos m\[AAcute]s pr\[OAcute]ximos, entonces ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  " debe estar en la normal a ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\)\(=\)\(g(x)\)\(\ \)\)\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\((b, g(b))\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\((b, g(b))\)\)]],
  " debe estar en la normal a ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, f(a))\)\)]],
  ". Se trata por ello de encontrar una normal com\[UAcute]n a ambas curvas."
}], "Text"],

Cell["Polinomios de Taylor", "Section"],

Cell[TextData[{
  "Recuerda que el polinomio de Taylor de orden ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " es la funci\[OAcute]n polin\[OAcute]mica ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(T(f, a, n)\) \((x)\)\), "=", 
          RowBox[{\(f(a)\), "+", 
            
            FormBox[\(\[Sum]\+\(k = 1\)\%n\(\(\( f\^\((k)\)\)(
                        a)\)\/\(k!\)\) \((x - a)\)\^k\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["Ejercicio 4.",
    FontWeight->"Bold"],
  " Define un comando que calcule polinomios de Taylor.\nObservaciones. La \
\[UAcute]nica dificultad que puedes encontrar es que no se calculen de forma \
apropiada las derivadas. Recuerda que en la pr\[AAcute]ctica anterior ya \
vimos que hab\[IAcute]a que tener cuidado con esto. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " proporciona varias formas de representar la derivada de orden k de una \
funci\[OAcute]n f de una variable t en un punto a. Puedes hacerlo con \
\"D[f[t],{t,k}] /. t\[Rule]a\" y tambi\[EAcute]n con \"Derivative[k][f][a]\". \
"
}], "Text"],

Cell[BoxData[
    \(PolinomioTaylor[f_, a_, n_, \[Lambda]_] := 
      Module[{var, temp}, 
        \[IndentingNewLine]If[NumberQ[f[N[a]]], 
          f[a] + Sum[
              \(\(Derivative[k]\)[f]\)[a]/\(k!\)*\((\[Lambda] - a)\)\^k, {k, 
                1, n}], 
          temp = Select[{x, y, z, t, u, v, w, s, r}, 
              \((NumberQ[f /. # \[Rule] N[a]]&)\)]; 
          If[Length[temp] \[Equal] 1, \[IndentingNewLine]{var} = temp; \n
            \t\t\t\t\((f /. var \[Rule] a)\) + 
              Sum[\((D[f, {var, k}] /. var \[Rule] a)\)/\(k!\)*
                  \((\[Lambda] - a)\)\^k, {k, 1, n}], 
            "\<En la funci\[OAcute]n debe figurar solamente una de las letras \
x,y,z,t,u,v,w,s,r. Dicha letra representar\[AAcute] a la variable de la funci\
\[OAcute]n.\>"]]]\)], "Input"],

Cell[BoxData[
    \(PolinomioTaylor[Sin[w], 0, 5, u]\)], "Input"],

Cell[BoxData[{
    \(\(poliTaylor[f_, a_, n_]\)[x_] := 
      f[a] + Sum[\(\(Derivative[k]\)[f]\)[a]/\(k!\)*\((x - a)\)\^k, {k, 1, n}]
          \), 
    \(\(nuevopoliTaylor[f_, var_, a_, n_]\)[x_] := 
      \((f /. var \[Rule] a)\) + 
        Sum[\((D[f, {var, k}] /. var \[Rule] a)\)/\(k!\)*\((x - a)\)\^k, {k, 
            1, n}]\)}], "Input"],

Cell[BoxData[{
    \(\(poliTaylor[Exp, 0, 5]\)[x]\  (*\ no\ funciona\ si\ pones\ Exp[t]\ *) 
      \), 
    \(\(nuevopoliTaylor[Exp[t], t, 0, 5]\)[x]\  (*\ 
      no\ funciona\ si\ pones\ Exp\ *) \)}], "Input"],

Cell[BoxData[
    \(\(TaylPoli[f_, var_, a_, n_]\)[x_] := 
      If[FreeQ[f, var] \[Equal] False, \(nuevopoliTaylor[f, var, a, n]\)[
          x], \(poliTaylor[f, a, n]\)[x]]\)], "Input"],

Cell[BoxData[{
    \(\(TaylPoli[Exp[t], t, 0, 5]\)[x]\), 
    \(\(\(TaylPoli[Exp, t, 0, 5]\)[x]\ \) (*\ 
      es\ obligado\ poner\ una\ variable\ como\ segundo\ argumento\ *) \)}], 
  "Input"],

Cell[BoxData[
    \(OtroPolinomioTaylor[f_, a_, n_, x_] := 
      If[NumberQ[f[N[a]]], 
        f[a] + Sum[\(\(Derivative[k]\)[f]\)[a]/\(k!\)*\((x - a)\)\^k, {k, 1, 
              n}], "\<La funci\[OAcute]n \>"\  <> 
          ToString[
            f] <> "\< debe representarse simb\[OAcute]licamente sin incluir \
ninguna variable. Ejemplo: Cos en vez de Cos[x].\>"\ ]\)], "Input"],

Cell[BoxData[
    \(\(nuevopoliTaylorbis[f_, a_, n_]\)[x_] := 
      Block[{var}, \[IndentingNewLine]{var} = 
          Select[{x, y, z, t, u, v, w, s, 
              r}, \((Not[FreeQ[f, #]] &)\)]; \[IndentingNewLine]\((f /. 
              var \[Rule] a)\) + 
          Sum[\((D[f, {var, k}] /. 
                    var \[Rule] a)\)/\(k!\)*\((x - a)\)\^k, {k, 1, 
              n}]]\)], "Input"],

Cell[BoxData[
    \(\(nuevoTaylPoli[f_, a_, n_]\)[x_] := 
      If[AtomQ[f], \(poliTaylor[f, a, n]\)[
          x], \(nuevopoliTaylorbis[f, a, n]\)[x]]\)], "Input"],

Cell[BoxData[{
    \(\(nuevoTaylPoli[Exp[t], 0, 5]\)[x]\  (*\ 
        podemos\ poner\ la\ funci\[OAcute]n\ con\ variable\ o\ sin\ variable
          \ *) \[IndentingNewLine]\(nuevoTaylPoli[Exp, 0, 5]\)[x]\), 
    \(\(\(nuevoTaylPoli[Exp[x], 0, 5]\)[x]\ \ \) (*\ 
      podemos\ poner\ la\ variable\ que\ queramos\ para\ la\ funci\[OAcute]n
        \ *) \)}], "Input"],

Cell[BoxData[
    \(polinomiotaylor[f_, a_, n_, x_] := 
      Block[{var}, \[IndentingNewLine]If[AtomQ[f], 
          f[a] + Sum[\(\(Derivative[k]\)[f]\)[a]/\(k!\)*\((x - a)\)\^k, {k, 
                1, n}], {var} = 
            Select[{x, y, z, t, u, v, w, s, 
                r}, \((Not[FreeQ[f, #]] &)\)]; \((f /. var \[Rule] a)\) + 
            Sum[\((D[f, {var, k}] /. 
                      var \[Rule] a)\)/\(k!\)*\((x - a)\)\^k, {k, 1, 
                n}]]]\)], "Input"],

Cell[BoxData[
    \(polinomiotaylor[f_, a_, n_, x_] := 
      Block[{var, temp}, \[IndentingNewLine]If[AtomQ[f], 
          f[a] + Sum[\(\(Derivative[k]\)[f]\)[a]/\(k!\)*\((x - a)\)\^k, {k, 
                1, n}], 
          temp = Select[{x, y, z, t, u, v, w, s, 
                r}, \((Not[FreeQ[f, #]] &)\)]; 
          If[Length[temp] \[Equal] 1, {var} = 
              temp; \((f /. var \[Rule] a)\) + 
              Sum[\((D[f, {var, k}] /. 
                        var \[Rule] a)\)/\(k!\)*\((x - a)\)\^k, {k, 1, 
                  n}], "\<En la funci\[OAcute]n debe figurar solamente una de \
las letras x,y,z,t,u,v,w,s,r. Dicha letra representar\[AAcute] a la variable \
de la funci\[OAcute]n.\>"\ ]]]\)], "Input"],

Cell[BoxData[{
    \(polinomiotaylor[Exp, 0, 10, x]\), 
    \(polinomiotaylor[Log[t], 1, 10, x]\), 
    \(polinomiotaylor[2^t, 0. , 10, x]\), 
    \(polinomiotaylor[2^a, 0. , 10, x]\)}], "Input"],

Cell[BoxData[
    \(taylorpol[
        f_?\((\((AtomQ[#1] \[Or] \((Not[AtomQ[#1]] && Not[FreeQ[#1, t]])\))
                \)&)\), a_, n_, x_?\((\((Not[# === t])\)&)\)] := 
      \[IndentingNewLine]If[AtomQ[f], 
        f[a] + Sum[
            \(\(Derivative[k]\)[f]\)[a]/\(k!\)*\((x - a)\)\^k, {k, 1, n}], 
        \((f /. t \[Rule] a)\) + 
          Sum[\((D[f, {t, k}] /. t \[Rule] a)\)/\(k!\)*\((x - a)\)\^k, {k, 1, 
              n}]]\)], "Input"],

Cell[BoxData[
    \(\(taylorpol::var = 
      "\<La variable de la funci\[OAcute]n debe ser la letra t y la variable \
del polinomio de Taylor debe ser distinta de t.\>"; \)\)], "Input"],

Cell[BoxData[
    \(taylorpol[expr1_, expr2_, expr3_, expr4_] /; Message[taylorpol::var] := 
      "\<llego ma\[NTilde]ana.\>"\)], "Input"],

Cell[BoxData[{
    \(taylorpol[Exp, 0, 10, x]\), 
    \(taylorpol[Log[t], 1, 10, x]\), 
    \(taylorpol[2^t, 0. , 10, x]\), 
    \(taylorpol[2^a, 0. , 10, x]\), 
    \(taylorpol[t*Sin[t], 0, 10, t]\)}], "Input"],

Cell[TextData[{
  StyleBox["Ejercicio 5.",
    FontWeight->"Bold"],
  " Utiliza el comando que has definido en el ejercicio anterior para hacer \
tres animaciones gr\[AAcute]ficas en las que respectivamente se vean las \
funciones seno, arcotangente y log(1+x) con sus polinomios de Taylor hasta el \
orden 20. Las funciones debes representarlas en rojo y los polinomios en \
azul. Debes elegir intervalos apropiados y fijar, con \"PlotRange[ ]\", un \
intervalo de representaci\[OAcute]n com\[UAcute]n para todas las \
gr\[AAcute]ficas de una misma animaci\[OAcute]n."
}], "Text"],

Cell["C\[AAcute]lculo de integrales", "Section"],

Cell[TextData[{
  StyleBox["Dada una partici\[OAcute]n ",
    FontSize->12],
  Cell[BoxData[
      \(TraditionalForm\`P = {x\_0 = a, \ x\_1, \ x\_2,  ... , \ 
          x\_\(n - 1\), x\_n = b}\)],
    FontSize->12],
  StyleBox[" del intervalo  ",
    FontSize->12],
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)],
    FontSize->12],
  StyleBox[", y un punto ",
    FontSize->12],
  Cell[BoxData[
      \(TraditionalForm\`t\_k \[Element] \([x\_\(k - 1\), x\_k]\)\)],
    FontSize->12],
  StyleBox[" en cada uno de los intervalos de la misma, el n\[UAcute]mero  ",
    FontSize->12],
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+\(k = 1\)\%n\( f(
            t\_k)\) \((x\_k - x\_\(k - 1\))\)\)],
    FontSize->12],
  "  ",
  StyleBox["se llama ",
    FontSize->12],
  StyleBox["una",
    FontSize->12,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSize->12],
  StyleBox["suma de Riemann",
    FontSize->12,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" de ",
    FontSize->12],
  StyleBox["f ",
    FontSize->12,
    FontSlant->"Italic"],
  StyleBox[" para la partici\[OAcute]n ",
    FontSize->12],
  StyleBox["P",
    FontSize->12,
    FontSlant->"Italic"],
  StyleBox[".",
    FontSize->12]
}], "Text",
  FontSize->14],

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["Ejercicio 6.",
    FontWeight->"Bold"],
  " Define un comando que calcule sumas de Riemann de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en un intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  ". Dicho comando debe dividir el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " partes iguales, evaluar la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`t\_k = \((1 - t)\) x\_\(k - 1\) + t\ x\_k\)]],
  " y calcular la suma de Riemann correspondiente. Al usar el comando hay que \
elegir para ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " alg\[UAcute]n valor entre 0 y 1. Define este comando de forma que puedas \
controlar la precisi\[OAcute]n con la que trabaja."
}], "Text"],

Cell[BoxData[
    \(sumariemann[f_, a_, b_, n_, p_:  20, t_:  0] := 
      N[\((b - a)\)/n, p] 
        Sum[N[f[\((1 - t)\) \((a + k \((b - a)\)/n)\) + 
                t \((a + \((k + 1)\) \((b - a)\)/n)\)], p], {k, 0, 
            n - 1}]\)], "Input"],

Cell["\<\
Los comandos b\[AAcute]sicos que se usan para calcular integrales son \
\"Integrate[ ]\" para hacer c\[AAcute]lculos simb\[OAcute]licos y \
\"Nintegrate[ ]\" para calcular una aproximaci\[OAcute]n num\[EAcute]rica de \
una integral. Estos comando tienen varias opciones que vamos a ver a \
continuaci\[OAcute]n.\
\>", "Text"],

Cell[BoxData[
    \(\(\(Integrate[x*Sin[x], x]\)\(\ \)\( (*\ 
      Integrate[f[x], x]\ proporciona\ una\ primitiva\ de\ f[
          x]\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(Integrate[x\^2*\ Exp[x], {x, \[Pi]/2, \[Pi]}]\)\(\ \)\( (*\ 
      Integrate[f[x], {x, a, b}]\ calcula\ el\ valor\ de\ la\ integral\ de\ f[
          x] en\ el\ intervalo\ [a, b], \ \(-\[Infinity]\) \[LessEqual] a < 
        b \[LessEqual] \[Infinity]\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Para calcular una integral definida que depende de un par\[AAcute]metro \
puedes informar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " de las carcater\[IAcute]sticas de dicho par\[AAcute]metro. Si no lo haces \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " intentar\[AAcute] dar una respuesta v\[AAcute]lida imponiendo, si es \
necesario, algunas restricciones al par\[AAcute]metro. Cuando se calculan \
primitivas ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no se preocupa de valores particulares de los par\[AAcute]metros. F\
\[IAcute]jate bien en las respuestas a los siguientes comandos."
}], "Text"],

Cell[BoxData[{
    \(Integrate[Exp[\(-a\)*x], x]\), 
    \(Integrate[Exp[\(-a\)*x], {x, 0, \[Infinity]}]\), 
    \(Integrate[Exp[\(-a\)*x], {x, 0, \[Infinity]}, Assumptions \[Rule] a > 0]
      \)}], "Input"],

Cell[TextData[{
  "En la primera ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " se ha limitado a calcular una primitiva. En la segunda dice que si el par\
\[AAcute]metro ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " tiene parte real positiva (quiz\[AAcute]s debas saber que para ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " todas las variables son por defecto variables complejas) la integral vale \
",
  Cell[BoxData[
      \(TraditionalForm\`1/a\)]],
  ". En la tercera nos da el valor de la integral cuando ",
  Cell[BoxData[
      \(TraditionalForm\`a > 0\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(NIntegrate[Exp[x^3], {x, 0, 1}]\)\( (*\ 
      NIntegrate[
          f[x], {x, a, 
            b}]\ calcula\ num\[EAcute]ricamente\ la\ integral\ de\ f[
          x]\ en\ el\ intervalo\ [a, b]\ *) \)\)\)], "Input"],

Cell["\<\
A veces el comando \"NIntegrate[ ]\" necesita ayuda. Aqu\[IAcute] tienes un \
ejemplo de esto.\
\>", "Text"],

Cell[BoxData[
    \(NIntegrate[\((1/x)\)*\ Sin[1/x], {x,  .001, 1}]\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " te informa de que el resultado no es fiable. En este caso es debido a que \
la funci\[OAcute]n oscila demasiado. Cuando esto ocurre podemos intentar \
aumentar el n\[UAcute]mero de iteraciones con la opci\[OAcute]n \
\"MaxRecursion\", la precisi\[OAcute]n de los c\[AAcute]lculos con la opci\
\[OAcute]n \"WorkingPrecision\" o bien usar otras opciones (que debes \
consultar en la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[BoxData[
    \(NIntegrate[\((1/x)\)*Sin[1/x], {x,  .001, 1}, 
      MaxRecursion \[Rule] 20]\)], "Input"],

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["Ejercicio 8.",
    FontWeight->"Bold"],
  " Calcula num\[EAcute]ricamente las integrales en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, 2  \[Pi]]\)\)]],
  " de los primeros 20 polinomios de Taylor de la funci\[OAcute]n coseno."
}], "Text"],

Cell[BoxData[
    \(Table[
      NIntegrate[\(poliTaylor[Cos, 0, k]\)[x], {x, 0, 2  \[Pi]}], {k, 2, 20, 
        2}]\)], "Input"],

Cell[TextData[{
  StyleBox["Ejercicio 9.",
    FontWeight->"Bold"],
  " Calcula sumas de Riemann de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f \((x)\)\  = \ \(\((1/x)\)\(\ \)\(Cos\) \((1/
              x)\)\(\ \)\)\)]],
  "en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0.001, 1]\)\)]],
  " y compara los valores obtenidos con los que proporciona el comando \
\"NIntegrate[ ]\" con las opciones oportunas. Debes lograr que la diferencia \
entre ambos resultados sea menor que 0.05. "
}], "Text"],

Cell[BoxData[{
    \(f[x_] := \((1/x)\)*Cos[1/x]\), 
    \(sumariemann[f, 1/1000, 1, 200]\)}], "Input"],

Cell[BoxData[
    \(NIntegrate[f[x], {x, 0.001, 1}]\)], "Input"],

Cell[BoxData[
    \(NIntegrate[f[x], {x, 0.001, 1}, MaxRecursion \[Rule] 40, 
      WorkingPrecision \[Rule] 30]\)], "Input"],

Cell[BoxData[
    \(sumariemann[f, 1/1000, 1, 50000, 30, 1/2]\)], "Input"],

Cell["C\[AAcute]lculo de \[AAcute]reas planas", "Section"],

Cell[TextData[{
  "El \[AAcute]rea comprendida entre dos curvas de ecuaciones ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x), \ y = g(x)\)]],
  " y las rectas ",
  Cell[BoxData[
      \(TraditionalForm\`x = a, \ x = b\)]],
  " viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\(\(|\)\(f(x) - 
            g(x)\)\(|\)\(\[DifferentialD]x\)\)\)]],
  ". Cuando no nos dicen expl\[IAcute]tamente el intervalo de integraci\
\[OAcute]n se entiende que debemos determinarlo calculando los puntos donde \
se cortan las curvas. Para calcular la integral ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\(\(|\)\(f(x) - 
            g(x)\)\(|\)\(\[DifferentialD]x\)\)\)]],
  " hay que partir el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  " en intervalos en los que la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) - g(x)\)]],
  " tenga signo constante para poder quitar el valor absoluto. Una \
representaci\[OAcute]n gr\[AAcute]fica puede ser muy \[UAcute]til."
}], "Text"],

Cell[CellGroupData[{

Cell["  Ejemplo 1", "Subsubsection"],

Cell[TextData[{
  "Calcular el \[AAcute]rea de la region \[CapitalOmega] del plano \
comprendida entre la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(-x\^2\) - 2  x + 10\)]],
  " y la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2  x - 1\)]],
  ".\nCalculamos primero las intersecciones de la par\[AAcute]bola con la \
recta lo que nos proporcionar\[AAcute] los l\[IAcute]mites de integraci\
\[OAcute]n. "
}], "Text"],

Cell[BoxData[
    \(x /. Solve[2  x - 1 \[Equal] \(-x\^2\) - 2  x + 10, x]\)], "Input"],

Cell["\<\
Representaremos ahora la regi\[OAcute]n \[CapitalOmega]. Puedes usar para \
ello la orden \"Plot\" o mejor el comando \"FilledPlot\".\
\>", "Text"],

Cell["<< Graphics`FilledPlot`", "Input",
  CellTags->"S5.31.1"],

Cell[BoxData[
    \(\(\(FilledPlot[{\(-x\^2\) - 2  x + 10, 2  x - 1}, {x, \(-7\), 
        3}]\)\(;\)\( (*\ \(-7\)\ es\ un\ poco\ m\[AAcute]s\ peque\[NTilde]o\ \
que\  - 2 - \@15\ y\ 3\ es\ algo\ mayor\ que\  - 2 + \@15\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Es claro que para  ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \[Epsilon]\ [\(-2\) - \@15, \(-2\) + \@15]\)]],
  "   la par\[AAcute]bola est\[AAcute] por encima de la recta. Por tanto, el \
\[AAcute]rea de \[CapitalOmega] viene dada por \t\t      \t \t\t\n\t\t\t\t\t\
",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(\[Integral]\_\(\(-2\) - \@15\)\%\(\(-2\) + \@15\)\),
              
              FontSize->
                18], \(\((\(-x\^2\) - 2  x + 
                  10 - \((2  x - 1)\))\) \[DifferentialD]x\)}], "=", 
          FormBox[\(20\ \@15\),
            "TraditionalForm"]}], TraditionalForm]]]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["  Ejemplo 2", "Subsubsection"],

Cell[TextData[{
  "Calcular el \[AAcute]rea de la regi\[OAcute]n \[CapitalOmega] comprendida \
entre la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`y\^2 = x\)]],
  " y la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = x - 2\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(x /. Solve[x \[Equal] \((x - 2)\)\^2, x]\)], "Input"],

Cell[BoxData[
    \(\(Plot[{x - 2, \(-\@x\), \ \@\(\(x\)\(\ \)\)}, {x, 0, 5}];\)\)], "Input"],

Cell[TextData[{
  "Observa que la regi\[OAcute]n est\[AAcute] limitada por inferiormente por \
las curvas de ecuaciones ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(-\@x\)\ \ \ \((0 \[LessEqual] x \[LessEqual] 
              1)\), \ \ y = 
        x - 2\ \ \((1 \[LessEqual] x \[LessEqual] 4)\)\)]],
  ". La curva superior es ",
  Cell[BoxData[
      \(TraditionalForm\`y = \@x\)]],
  ". En consecuencia, el \[AAcute]rea de \[CapitalOmega] viene dada por"
}], "Text"],

Cell[BoxData[
    \(Integrate[\@x - \((\(-\@x\))\), {x, 0, 1}] + 
      Integrate[\@x - \((x - 2)\), {x, 1, 4}]\)], "Input"]
}, Open  ]],

Cell[TextData[{
  "En situaciones parecidas a esta yo aconsejo, simplemente, cambiar ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " por ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " en las ecuaciones. Con ello lo que hacemos es una simetr\[IAcute]a \
respecto de la recta ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\)]],
  " lo cual no afecta al \[AAcute]rea de las figuras. Observa la diferencia \
si convertimos nuestra regi\[OAcute]n considerando las curvas ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 = y, \ x = y - 2\)]],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2, \ y = x + 2\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(x /. Solve[x^2 \[Equal] x + 2, x]\)], "Input"],

Cell[BoxData[
    \(\(Plot[{x^2, x + 2}, {x, \(-2\), 3}];\)\)], "Input"],

Cell["\<\
Aunque no lo parezca, por el cambio de escala, esta regi\[OAcute]n es la sim\
\[EAcute]trica de la anterior respecto de la bisectriz del primer cuadrante. \
Comprob\[EAcute]moslo.\
\>", "Text"],

Cell[BoxData[{
    \(h[x_] := \(-\@x\) /; 0 \[LessEqual] x \[LessEqual] 1\), 
    \(h[x_] := x - 2 /; 1 \[LessEqual] x \[LessEqual] 4\), 
    \(\(Show[{
        FilledPlot[{h[x], \@x}, {x, 0, 4}, AspectRatio \[Rule] Automatic, 
          Fills \[Rule] Hue[ .4], DisplayFunction \[Rule] Identity], 
        FilledPlot[{x\^2, x + 2}, {x, \(-1\), 2}, 
          AspectRatio \[Rule] Automatic, Fills \[Rule] Hue[ .8], 
          DisplayFunction \[Rule] Identity]}, 
      DisplayFunction \[Rule] $DisplayFunction]; \)\)}], "Input"],

Cell["Ahora es m\[AAcute]s sencillo calcular el \[AAcute]rea:", "Text"],

Cell[BoxData[
    \(Integrate[x + 2 - x^2, {x, \(-1\), 2}]\)], "Input"],

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["Ejercicio 10.",
    FontWeight->"Bold"],
  " Calcula las \[AAcute]reas de las regiones del plano limitadas por las \
siguientes curvas.\n",
  StyleBox["a",
    FontWeight->"Bold"],
  StyleBox[")",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(-x\^2\) - 2  x\)]],
  "  e  ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2 - 4\)]],
  ", para  ",
  Cell[BoxData[
      \(TraditionalForm\`\(-3\) \[LessEqual] \ \ x \[LessEqual] \ 1\)]],
  ".\n",
  StyleBox["b",
    FontWeight->"Bold"],
  StyleBox[") ",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`y\^2 = x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = 8\)]],
  ".\n",
  StyleBox["c",
    FontWeight->"Bold"],
  StyleBox[")",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`x = 12  y\^2 - 12  y\^3\)]],
  "  y  ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(x = 2  y\^2 - 2  y\)\)\)]],
  ".\n",
  StyleBox["d",
    FontWeight->"Bold"],
  StyleBox[")",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(sec\^2\) x, \ \ y = \(tg\^2\) x, \ \(-\[Pi]\)/
          4 \[LessEqual] \ x \[LessEqual] \ \[Pi]/4\)]],
  ".\n",
  StyleBox["e)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`\((y - x)\)\^2 = x - 3\)]],
  ",  y  ",
  Cell[BoxData[
      \(TraditionalForm\`x = 7\)]],
  ".\n",
  StyleBox["f)  ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`y = x\^4 + x\^3 + 16  x - 4\)]],
  "  y  ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^4 + 6  x\^2 + 8  x - 4\)]],
  ". \n",
  StyleBox["g)",
    FontWeight->"Bold"],
  "  ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\ e\^\(-x\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(x\^2\) e\^\(-x\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`x \[GreaterEqual] \ 0\)]],
  "."
}], "Text"],

Cell["\<\
C\[AAcute]lculo del \[AAcute]rea de la regi\[OAcute]n rodeada por una curva \
cerrada dada por sus ecuaciones param\[EAcute]tricas\
\>", "Subsubsection"],

Cell[TextData[{
  "Sea \[CapitalOmega] la regi\[OAcute]n rodeada por una curva ",
  StyleBox["cerrada ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(es decir, que su punto inicial coincide con su punto final)",
  StyleBox[" simple ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(es decir, sin autointersecciones) de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\), \ \((a \[LessEqual] 
          t \[LessEqual] b)\)\)]],
  " y supongamos que las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`t \[RightArrow] \ x(t), \ 
      t \[RightArrow] \ y(t)\)]],
  " tienen primera derivada continua. En estas condiciones se verifica que el \
\[AAcute]rea de \[CapitalOmega] viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            RowBox[{"|", 
              RowBox[{
                SubsuperscriptBox["\[Integral]", 
                  StyleBox["a",
                    FontSize->10], "b"], \(\(y(t)\) 
                  x' \((t)\) \[DifferentialD]t\)}], " ", "|"}], 
            "=", \(\(|\)\(\[Integral]\_a\%b\( x(t)\) 
                  y' \((t)\) \[DifferentialD]t\)\(\ \)\(|\)\)}]}], 
        TraditionalForm]]],
  " (la igualdad entre las dos integrales se deduce f\[AAcute]cilmente \
integrando por partes y teniendo en cuenta que por ser ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " una curva cerrada es ",
  Cell[BoxData[
      \(TraditionalForm\`\(x(b)\) \(y(b)\) - \(x(a)\) \(y(a)\) = 0\)]],
  ")."
}], "Text"],

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["Ejercicio 11. ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Calcula el \[AAcute]rea encerrada por un arco de la cicloide ",
  Cell[BoxData[
      \(TraditionalForm\`x \((t)\) = r\ \((t - sen\ t)\), \ \ y \((t)\) = 
        r\ \((1 - \ cos\ t)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((0 \[LessEqual] t \[LessEqual] \ 2  \[Pi])\)\)]],
  ".\n",
  StyleBox["b) ",
    FontWeight->"Bold"],
  "Calcula e",
  "l \[AAcute]rea encerrada por la elipse  ",
  Cell[BoxData[
      \(TraditionalForm\`x(t) = \[Alpha]\  + a\ cos\ t, \ 
      y(t) = \[Beta] + \ b\ sen\ t\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((0 \[LessEqual] t \[LessEqual] \ 2  \[Pi])\)\)]],
  ".\n",
  StyleBox["c) ",
    FontWeight->"Bold"],
  StyleBox["Calcula el \[AAcute]rea encerrada por la cardioide  ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox[\(x = cos\ t\ \((1 + cos\ t)\)\),
            FontWeight->"Plain"], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[" ",
            FontWeight->"Plain"], 
          RowBox[{
            StyleBox["y",
              FontWeight->"Plain"], 
            StyleBox["=",
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox["sen",
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[" ",
                FontWeight->"Plain"], 
              RowBox[{"(", 
                StyleBox[\(1 + cos\ t\),
                  FontWeight->"Plain"], 
                StyleBox[")",
                  FontWeight->"Plain"]}]}]}], 
          StyleBox[",",
            FontWeight->"Plain"], 
          StyleBox[\((0 \[LessEqual] t \[LessEqual] \ 2  \[Pi])\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  ". "
}], "Text"],

Cell["C\[AAcute]lculo de longitudes de curvas", "Section"],

Cell[TextData[{
  "La longitud de una curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " dada por sus ecuaciones cartesianas ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(x)\)]],
  " viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\(\@\( 
                1 + \((f' \((x)\))\)\^2\)\) \[DifferentialD]x\)]],
  ". Para el caso de que la curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " venga dada por las ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      FormBox[
        TagBox[
          StyleBox[
            RowBox[{"{", 
              StyleBox[GridBox[{
                    {\(x = x(t)\)},
                    {\(y = y(t)\)}
                    }],
                ShowAutoStyles->True]}],
            ShowAutoStyles->False],
          (#&)], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((a \[LessEqual] \ t \[LessEqual] \ b)\)\)]],
  " donde suponemos que las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Rule] x(t), \ t \[Rule] \ y(t)\)]],
  "tienen derivada primera continua, la longitud de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma]\)]],
  " es igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\_a\%b\(\@\( x' \((t)\)\^2 + 
                y' \((t)\)\^2\)\) \[DifferentialD]t\)]],
  "."
}], "Text"],

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["Ejercicio 12.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Calcula la longitud ",
  StyleBox["de un arco de la cicloide ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = t - \ sen\ t, \ y = \ 1 - cos\ t\),
          FontWeight->"Plain"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\((0 \[LessEqual] t \[LessEqual] \ 2  \[Pi])\)\)]],
  ".\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " ",
  StyleBox["Calcular la longitud del arco de curva ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2 + 4\)],
    FontWeight->"Plain"],
  StyleBox[",",
    FontWeight->"Plain"],
  " ",
  StyleBox["entre ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = 0\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = 3\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[".",
    FontWeight->"Plain"]
}], "Text"],

Cell["C\[AAcute]lculo de \[AAcute]reas de superficies de revoluci\[OAcute]n", \
"Section"],

Cell[TextData[{
  "Una superficie de revoluci\[OAcute]n se obtiene girando una curva dada \
alrededor de una recta. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`f : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " una funci\[OAcute]n con derivada primera continua. Girando la \
gr\[AAcute]fica de dicha funci\[OAcute]n alrededor del eje OX obtenemos una \
superficie de revoluci\[OAcute]n cuya \[AAcute]rea viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`2  \[Pi] \(\[Integral]\_a\%b\( f(
              x)\) \(\@\(1 + f' \((x)\)\^2\)\) \[DifferentialD]x\)\)]],
  "."
}], "Text"],

Cell["Ejercicios", "Subsection"],

Cell[TextData[{
  StyleBox["Ejercicio 13.",
    FontWeight->"Bold"],
  "\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Calcula el \[AAcute]rea de una superficie esf\[EAcute]rica de radio ",
  StyleBox["R.\n",
    FontSlant->"Italic"],
  StyleBox["b)",
    FontWeight->"Bold"],
  " ",
  StyleBox["Calcula el  \[AAcute]rea de la superficie de revoluci\[OAcute]n \
engendrada al girar la curva ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`y = x\^3\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] x \[LessEqual] 1\)]],
  ", alrededor del eje OX."
}], "Text"]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1024}, {0, 688}},
AutoGeneratedPackage->None,
CellGrouping->Manual,
WindowSize->{994, 611},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.31.1"->{
    Cell[32669, 922, 63, 1, 71, "Input",
      CellTags->"S5.31.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.31.1", 46772, 1389}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 116, 5, 82, "Title"],
Cell[1828, 56, 42, 0, 62, "Subtitle"],

Cell[CellGroupData[{
Cell[1895, 60, 58, 0, 83, "Section"],
Cell[1956, 62, 516, 17, 72, "Text"],
Cell[2475, 81, 234, 5, 122, "Input"],
Cell[2712, 88, 369, 11, 67, "Text"],
Cell[3084, 101, 89, 1, 72, "Input"],
Cell[3176, 104, 89, 2, 98, "Input"],
Cell[3268, 108, 370, 11, 75, "Text"],
Cell[3641, 121, 283, 5, 148, "Input"],
Cell[3927, 128, 94, 2, 98, "Input"],
Cell[4024, 132, 500, 17, 67, "Text"],
Cell[4527, 151, 1129, 22, 358, "Input"]
}, Open  ]],
Cell[5671, 176, 270, 6, 75, "Text"],
Cell[5944, 184, 548, 10, 280, "Input"],
Cell[6495, 196, 463, 10, 79, "Text"],
Cell[6961, 208, 648, 12, 363, "Input"],
Cell[7612, 222, 496, 12, 84, "Text"],
Cell[8111, 236, 1215, 21, 595, "Input"],

Cell[CellGroupData[{
Cell[9351, 261, 42, 0, 83, "Section"],
Cell[9396, 263, 112, 3, 41, "Text"],
Cell[9511, 268, 86, 1, 92, "Input"],
Cell[9600, 271, 796, 16, 254, "Input"]
}, Open  ]],
Cell[10411, 290, 69, 0, 83, "Section"],
Cell[10483, 292, 359, 6, 93, "Text"],
Cell[10845, 300, 607, 11, 228, "Input"],
Cell[11455, 313, 91, 1, 72, "Input"],
Cell[11549, 316, 205, 4, 98, "Input"],
Cell[11757, 322, 94, 2, 41, "Text"],
Cell[11854, 326, 613, 11, 228, "Input"],
Cell[12470, 339, 207, 4, 98, "Input"],
Cell[12680, 345, 409, 7, 93, "Text"],
Cell[13092, 354, 278, 5, 124, "Input"],
Cell[13373, 361, 280, 5, 124, "Input"],

Cell[CellGroupData[{
Cell[13678, 370, 104, 2, 72, "Input"],
Cell[13785, 374, 108, 2, 72, "Input"]
}, Open  ]],
Cell[13908, 379, 292, 4, 124, "Input"],
Cell[14203, 385, 32, 0, 68, "Subsection"],
Cell[14238, 387, 103, 3, 41, "Text"],
Cell[14344, 392, 332, 10, 41, "Text"],
Cell[14679, 404, 1290, 39, 157, "Text"],
Cell[15972, 445, 39, 0, 83, "Section"],
Cell[16014, 447, 631, 20, 101, "Text"],
Cell[16648, 469, 32, 0, 68, "Subsection"],
Cell[16683, 471, 648, 13, 157, "Text"],
Cell[17334, 486, 802, 15, 254, "Input"],
Cell[18139, 503, 65, 1, 72, "Input"],
Cell[18207, 506, 346, 7, 150, "Input"],
Cell[18556, 515, 210, 4, 98, "Input"],
Cell[18769, 521, 187, 3, 98, "Input"],
Cell[18959, 526, 193, 4, 124, "Input"],
Cell[19155, 532, 382, 7, 150, "Input"],
Cell[19540, 541, 395, 8, 124, "Input"],
Cell[19938, 551, 164, 3, 98, "Input"],
Cell[20105, 556, 368, 6, 176, "Input"],
Cell[20476, 564, 480, 9, 150, "Input"],
Cell[20959, 575, 723, 13, 228, "Input"],
Cell[21685, 590, 195, 4, 150, "Input"],
Cell[21883, 596, 452, 9, 150, "Input"],
Cell[22338, 607, 186, 3, 98, "Input"],
Cell[22527, 612, 139, 2, 98, "Input"],
Cell[22669, 616, 211, 5, 176, "Input"],
Cell[22883, 623, 581, 10, 119, "Text"],
Cell[23467, 635, 48, 0, 83, "Section"],
Cell[23518, 637, 1277, 49, 70, "Text"],
Cell[24798, 688, 32, 0, 68, "Subsection"],
Cell[24833, 690, 928, 27, 119, "Text"],
Cell[25764, 719, 253, 5, 98, "Input"],
Cell[26020, 726, 335, 6, 67, "Text"],
Cell[26358, 734, 158, 3, 98, "Input"],
Cell[26519, 739, 297, 4, 124, "Input"],
Cell[26819, 745, 667, 16, 119, "Text"],
Cell[27489, 763, 208, 4, 124, "Input"],
Cell[27700, 769, 617, 19, 93, "Text"],
Cell[28320, 790, 238, 5, 98, "Input"],
Cell[28561, 797, 118, 3, 41, "Text"],
Cell[28682, 802, 80, 1, 72, "Input"],
Cell[28765, 805, 535, 12, 93, "Text"],
Cell[29303, 819, 110, 2, 72, "Input"],
Cell[29416, 823, 32, 0, 68, "Subsection"],
Cell[29451, 825, 286, 7, 67, "Text"],
Cell[29740, 834, 129, 3, 72, "Input"],
Cell[29872, 839, 533, 13, 93, "Text"],
Cell[30408, 854, 103, 2, 98, "Input"],
Cell[30514, 858, 64, 1, 72, "Input"],
Cell[30581, 861, 125, 2, 72, "Input"],
Cell[30709, 865, 74, 1, 72, "Input"],
Cell[30786, 868, 58, 0, 83, "Section"],
Cell[30847, 870, 1056, 25, 148, "Text"],

Cell[CellGroupData[{
Cell[31928, 899, 36, 0, 55, "Subsubsection"],
Cell[31967, 901, 449, 11, 79, "Text"],
Cell[32419, 914, 87, 1, 72, "Input"],
Cell[32509, 917, 157, 3, 41, "Text"],
Cell[32669, 922, 63, 1, 71, "Input",
  CellTags->"S5.31.1"],
Cell[32735, 925, 241, 3, 104, "Input"],
Cell[32979, 930, 688, 18, 117, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33704, 953, 36, 0, 55, "Subsubsection"],
Cell[33743, 955, 270, 9, 41, "Text"],
Cell[34016, 966, 73, 1, 72, "Input"],
Cell[34092, 969, 93, 1, 79, "Input"],
Cell[34188, 972, 472, 11, 67, "Text"],
Cell[34663, 985, 124, 2, 83, "Input"]
}, Open  ]],
Cell[34802, 990, 659, 19, 114, "Text"],
Cell[35464, 1011, 66, 1, 71, "Input"],
Cell[35533, 1014, 72, 1, 72, "Input"],
Cell[35608, 1017, 203, 4, 66, "Text"],
Cell[35814, 1023, 527, 9, 225, "Input"],
Cell[36344, 1034, 71, 0, 40, "Text"],
Cell[36418, 1036, 71, 1, 72, "Input"],
Cell[36492, 1039, 32, 0, 67, "Subsection"],
Cell[36527, 1041, 1930, 79, 306, "Text"],
Cell[38460, 1122, 163, 3, 54, "Subsubsection"],
Cell[38626, 1127, 1560, 40, 120, "Text"],
Cell[40189, 1169, 32, 0, 67, "Subsection"],
Cell[40224, 1171, 1966, 62, 154, "Text"],
Cell[42193, 1235, 58, 0, 82, "Section"],
Cell[42254, 1237, 1342, 41, 111, "Text"],
Cell[43599, 1280, 32, 0, 67, "Subsection"],
Cell[43634, 1282, 1098, 43, 117, "Text"],
Cell[44735, 1327, 90, 1, 82, "Section"],
Cell[44828, 1330, 595, 12, 94, "Text"],
Cell[45426, 1344, 32, 0, 67, "Subsection"],
Cell[45461, 1346, 604, 21, 117, "Text"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

